# Archivos de validación para el Informe de Evaluación Energética del Edificio en formato XML v3.0

## Contenido

Este documento describe los archivos que implementan los esquemas de validación correspondientes al desarrollo del [Documento Reconocido de la Certificación de eficiencia energética de los edificios](https://energia.gob.es/desarrollo/EficienciaEnergetica/CertificacionEnergetica/DocumentosReconocidos/Paginas/documentosreconocidos.aspx) **Informe de evaluación energética del edificio en formato XML** en su versión 3.0.

Dicho documento describe el contenido y estructura del Informe de evaluación energética en formato electrónico (XML), idóneo para el intercambio electrónico de datos, con el mismo alcance que el Certificado de Eficiencia Energética. El contenido del informe incluye información suficiente para la emisión del Certificado de Eficiencia Energética y la justificación de algunos aspectos del [Documento Básico de Ahorro de energía del Código Técnico de la Edificación (CTE DB-HE)](https://www.codigotecnico.org/DocumentosCTE/AhorroEnergia.html).

Para la validación de documentos XML conformes a la especificación se proporcionan distintos esquemas de validación:

- Un esquema de referencia en formato RelaxNG Compacto (extensión .rnc)
- Esquemas en formato XSD (extensión .xsd) para los distintos registros catastrales (DGC, AFA, BFA, GFA, RRTN)

## Registro de cambios en los esquemas de validación

Tras el periodo de pruebas con los documentos XML emitidos por las herramientas reconocidas se han realizado cambios en los esquemas de validación para corregir erratas y problemas de validación.

Los cambios realizados son:

- Corrección de errata en patrón de FECHA_CONSTRUCCION para permitir años completos (e.g. 1976)
- Ampliación de la longitud máxima de las claves de metadatos (CLAVE_METADATO) a 50 caracteres para permitir el uso de claves ya actualmente en uso y estandarizadas en v2.1, como CTE_DEMANDA_ACS_PCT_BIOMASADENSIFICADA, que son necesarias para el cálculo de indicadores.
- Los esquemas XSD han sido regenerados manualmente con los cambios anteriores y además:
  - Suministrando de esquemas XSD separados para cada registro, ya que el esquema combinado no permite la validación por ambigüedades no resolubles con XSD1.0
  - Corregida la existencia de comentarios con dobles guiones no permitidos, que impiden la validación
  - Evitando ambigüedades existentes en la versión generada automáticamente a partir del esquema RNC que facilitaba la validación de documentos incorrectos debido a las limitaciones de algunas construcciones XSD1.0.
- Para facilitar el uso, se suministran esquemas combinados en un solo archivo, en lugar de los dos archivos anteriores, en los que se separaba la definición de tipos básicos de la definición de elementos.

## Validación de archivos XML

### Usando el esquema de datos en formato XSD

Para la validación de documentos se recomienda el uso de un validador para [XML Schema](https://www.w3.org/XML/Schema) (formato XSD) como:

- [`xmllint`](http://xmlsoft.org/xmllint.html):

    ```console
        xmllint --noout --schema DatosEnergeticosDelEdificio30.xsd EjemploResidencial.xml
    ```

- [Xerces2 Java](http://xerces.apache.org/xerces2-j/), usando [`xsd11-validator`](https://github.com/jeszy75/xsd11-validator):

    ```console
        java -jar xsd11-validator.jar -sf DatosEnergeticosDelEdificio30.xsd -if EjemploResidencial.xml
    ```

### Usando el esquema de datos en formato RELAX NG (compacto)

Para el desarrollo del esquema se utiliza el [formato compacto](https://relaxng.org/compact-20021121.html) de [RelaxNG](https://relaxng.org/) por resultar más legible y más expresivo que otras alternativas.

Se recomienda el uso del [proyecto jing-trang](https://github.com/relaxng/jing-trang) para la validación usando el esquema RNC. La página del proyecto [jing](https://relaxng.org/jclark/jing.html) dispone de ayuda sobre la herramienta.

La validación de un documento XML se realiza del siguiente modo:

```console
 jing -c DatosEnergeticosDelEdificioSchema30.rnc EjemploResidencial.xml
```

La validación del propio esquema se realiza del siguiente modo:

```console
jing -c DatosEnergeticosDelEdificioSchema30.rnc
```

[jing](https://relaxng.org/jclark/jing.html)

## Desarrollo de los esquemas de validación

Grupo de energética edificatoria - Unidad de Calidad en la Construcción, Instituto Eduardo Torroja de Ciencias de la Construcción, IETcc-CSIC

- Rafael Villar Burke (pachi@ietcc.csic.es)
- Daniel Jiménez González (danielj@ietcc.csic.es)
- Marta Sorribes Gil (msorribes@ietcc.csic.es)
